using System;
using System.Collections.Generic;
using System.Linq;

public class Resenje
{
    private class Pomesaj
    {
        public int Indeks { get; set; }
        public long X { get; set; }
        public long Y { get; set; }
    }

    public static void Main(string[] args)
    {
        if (!int.TryParse(Console.ReadLine(), out int n)) return;

        List<Pomesaj> sviPomesaji = new List<Pomesaj>();
        for (int i = 0; i < n; i++)
        {
            string line = Console.ReadLine();
            if (string.IsNullOrEmpty(line)) continue;
            string[] parts = line.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            
            if (parts.Length == 2 && 
                long.TryParse(parts[0], out long x) && 
                long.TryParse(parts[1], out long y))
            {
                sviPomesaji.Add(new Pomesaj { Indeks = i + 1, X = x, Y = y });
            }
        }

        if (sviPomesaji.Count == 0)
        {
            Console.WriteLine(0);
            Console.WriteLine("");
            return;
        }

        long Rx = sviPomesaji.Sum(p => p.X);
        long Ry = sviPomesaji.Sum(p => p.Y);

        long maxKvadratDistanca = Rx * Rx + Ry * Ry;
        List<int> najboljiIndeksi = sviPomesaji.Select(p => p.Indeks).ToList();

        int indeksZaIzbacivanje = -1;

        for (int i = 0; i < n; i++)
        {
            long pomX = sviPomesaji[i].X;
            long pomY = sviPomesaji[i].Y;

            long Rx_prime = Rx - pomX;
            long Ry_prime = Ry - pomY;

            long trenutnaKvadratDistanca = Rx_prime * Rx_prime + Ry_prime * Ry_prime;

            if (trenutnaKvadratDistanca > maxKvadratDistanca)
            {
                maxKvadratDistanca = trenutnaKvadratDistanca;
                indeksZaIzbacivanje = sviPomesaji[i].Indeks;
            }
        }

        if (indeksZaIzbacivanje != -1)
        {
            najboljiIndeksi = sviPomesaji
                .Where(p => p.Indeks != indeksZaIzbacivanje)
                .Select(p => p.Indeks)
                .ToList();
        }

        Console.WriteLine(najboljiIndeksi.Count);
        Console.WriteLine(string.Join(" ", najboljiIndeksi));
    }
}